﻿using Newtonsoft.Json;
using System;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using Thinktecture.IdentityModel.Hawk.Client;
using Thinktecture.IdentityModel.Hawk.Core;
using Thinktecture.IdentityModel.Hawk.Core.Helpers;

namespace DemoAPICall
{
    class Program
    {
        //  Put your SensusAccess UserId
        private static readonly string USER_ID = "Put your UserId";
        // Put your SensusAccess API Key
        private static readonly string API_KEY = "Put your API Key";

        private static readonly string API_BASE_URL = "https://apibeta.sensusaccess.com/job";

        private static string jobID = "";
        static void Main(string[] args)
        {
            Console.WriteLine("[ ] Started.");
            var credential = new Credential()
            {
                Id = USER_ID,
                Algorithm = SupportedAlgorithms.SHA256,
                User = "TestUser",
                Key = Encoding.UTF8.GetBytes(API_KEY)
            };

            var options = new ClientOptions()
            {
                CredentialsCallback = () => credential,
                RequestPayloadHashabilityCallback = (r) => true,
                NormalizationCallback = (req) =>
                {
                    string name = "X-Request-Header-To-Protect";
                    return req.Headers.ContainsKey(name) ?
                                name + ":" + req.Headers[name].First()
                                                              : null;
                }
            };

            Console.WriteLine("[ ] Hawk authentication header created!");
            using (var client = HttpClientFactory.Create(new HawkValidationHandler(options)))
            {
                //POST job
                string targetDocumentFormat = "OFF_Text";

                // Path of the file which you want to sent to the API. Put your computer path where you want to save the file
                byte[] fileContent = System.IO.File.ReadAllBytes(@"C:\Everest.docx");
                client.BaseAddress = new Uri(API_BASE_URL);

                MultipartFormDataContent form = new MultipartFormDataContent();
                var httpFileContent = new ByteArrayContent(fileContent);
                httpFileContent.Headers.ContentType = new MediaTypeHeaderValue("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                form.Add(httpFileContent, "FileContent", "Everest.docx");
                form.Add(new StringContent(targetDocumentFormat), "TargetDocumentFormat");

                // DeliveryMethod, DeliveryEmail, UILanguage are optional. If you provide DeliveryMethod=Email, then you need to provide DeliveryEmail
                // to deliver the conversion result. Don't delete the job from the server if you supply the DeliveryMethod=Email, otherwise the link
                // in the delivery email would not point the file because the file has been deleted.
                // See the guide at https://apibeta.sensusaccess.com/home/guide to know more

                form.Add(new StringContent("Email"), "DeliveryMethod");
                form.Add(new StringContent("dp@sensus.dk"), "DeliveryEmail");
                form.Add(new StringContent("en-GB"), "UILanguage");

                HttpResponseMessage response = client.PostAsync(API_BASE_URL + "/Accessibility", form).Result;
                if (response.IsSuccessStatusCode)
                {
                    jobID = response.Content.ReadAsAsync<string>().Result;
                    Console.WriteLine("[ ] Post Job Success: " + jobID);
                }
                else
                {
                    Console.WriteLine($"[x] Post Job failure: {response.StatusCode}");
                    return;
                }
            }

            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri(API_BASE_URL);
                //GET status
                int status = 6;
                Console.Write("[ ] Waiting for job to finish");

                /* 
                 * Calling GetStatus API to get the latest status of the posted job and keep on calling the API every 2 seconds until it returns the
                 * Status less than two i.e. -1 is job doesn't complete successfully or 1 if the job completed successfully. Alternatively, you can also
                 * call the API GetJobStatus which would give you ErrorCode and ErrorMessage as well in case there is an error while processing the job
                */

                while ((status = int.Parse(client.GetStringAsync(API_BASE_URL + "/GetStatus?id=" + jobID).Result.Replace("\"", ""))) > 2)
                {
                    System.Threading.Thread.Sleep(2000);
                    Console.Write(".");
                }
                Console.WriteLine();

                // If the job is completed successfully, you can fetch the result with GetResult API call.
                if (status == 1)
                {
                    //GET result
                    var result = client.GetAsync(API_BASE_URL + "/GetResult?id=" + jobID).Result;
                    if (result.IsSuccessStatusCode)
                    {
                        var file = result.Content.ReadAsByteArrayAsync().Result;
                        var name = result.Content.Headers.ContentDisposition.FileName;

                        // Path to save the fetched contents from the API. Put your computer path where you want to save the file
                        if (!Directory.Exists(@"C:\FilesOutput"))
                            Directory.CreateDirectory(@"C:\FilesOutput");

                        System.IO.File.WriteAllBytes(@"C:\FilesOutput\\" + name, file);
                        Console.WriteLine($"[ ] Job successful! File {name} downloaded successfully.");
                    }
                }
                else // When there is an error, you can retrieve the error message by calling the API GetJobStatus
                {
                    var jsonResult = client.GetStringAsync(API_BASE_URL + "/GetJobStatus?id=" + jobID).Result;
                    JobStatusViewModel jobStatusViewModel = JsonConvert.DeserializeObject<JobStatusViewModel>(jsonResult);

                    Console.WriteLine($"[x] Job failed. Job status = {jobStatusViewModel.JobStatus} " +
                        $"Error code = {jobStatusViewModel.ErrorCode} ErrorMessage = {jobStatusViewModel.ErrorMessage}");
                }
            }

            /*
               Don't Delete the job form the Server if your have supplied DeliveryMethod=Email because the link on the delivered mail
               will not give you result because the result has been deleted
            */

            using (var client = HttpClientFactory.Create(new HawkValidationHandler(options)))
            {
                client.BaseAddress = new Uri(API_BASE_URL);

                //DELETE job

                var deleteResult = client.GetAsync(API_BASE_URL + "/Delete?id=" + jobID).Result;

                if (deleteResult.IsSuccessStatusCode)
                {
                    Console.WriteLine($"[ ] Deleted job with id: {deleteResult.Content.ReadAsAsync<string>().Result}");
                }
                else
                {
                    Console.WriteLine("[x] Failed to delete job!");
                }
            }

            Console.WriteLine("[ ] Finished! Press any key to exit...");
            Console.ReadLine();
        }
    }
    public class JobStatusViewModel
    {
        public Guid JobID { get; set; }
        public int JobStatus { get; set; }
        public string ErrorCode { get; set; }
        public string ErrorMessage { get; set; }
    }

}